using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace cifXTest
{
    public partial class cifXDownload : Form
    {
        private cifXUser    cifXUser    = new cifXUser();
        private cifxBase    cifXBase    = new cifxBase();
        private const int   CONFIG      = 0;
        private const int   FILE        = 1;
        private const int   FW          = 2;
        private const int   LIC         = 3;

        private string sFilePath        = "";
        private string sFileName        = "";
        private byte[] abFileData;

        public cifXDownload()
        {
            InitializeComponent();
        }

        private void cifXDownload_Load(object sender, EventArgs e)
        {
            this.cmbMode.BeginUpdate();
            this.cmbMode.Items.Clear();

            /*  constants for file download as they are defined in cifXUser.cs
                DOWNLOAD_MODE_FIRMWARE    = 1;
                DOWNLOAD_MODE_CONFIG      = 2;
                DOWNLOAD_MODE_FILE        = 3;
                DOWNLOAD_MODE_BOOTLOADER  = 4; 
                DOWNLOAD_MODE_LICENSECODE = 5; 
            */

            this.cmbMode.Items.Add("Configuration Download");
            this.cmbMode.Items.Add("File Download");
            this.cmbMode.Items.Add("Firmware Download");
            this.cmbMode.Items.Add("License Download");

            if (cifXUser.hChannel != 0)
            {
                this.cmbMode.SelectedIndex  = CONFIG;
                this.txtChannel.Text        = cifXUser.ActiveChannel.ToString();
                this.txtChannel.Enabled     = false;
            }
            else
            {
                this.cmbMode.SelectedIndex  = FW;
                this.txtChannel.Text        = "0";
                this.txtChannel.Enabled     = true;
            }

            this.cmbMode.EndUpdate();
        }

        private void btnSelFile_Click(object sender, EventArgs e)
        {
            FileDialog  dlgFileOpen = new OpenFileDialog();
            int         iSelIndex   = this.cmbMode.SelectedIndex;
            
            switch (iSelIndex)
            {
                case CONFIG:
                    dlgFileOpen.Filter = "netX Configuration File (*.nxd, *.dbm)|*.nxd, *.dbm";
                    break;
                case FILE:
                    dlgFileOpen.Filter = "All Files (*.*)|*.*";
                    break;
                case FW:
                    dlgFileOpen.Filter = "netX Firmware Files (*.nxf, *.nxm, *.mod)|*.nxf; *.nxm; *.mod";
                    break;
                case LIC:
                    dlgFileOpen.Filter = "netX License Files (*.nxl)|*.nxl";
                    break;
            }
            
            if (dlgFileOpen.ShowDialog() != DialogResult.Cancel)
            {
                this.txtFilename.Text = dlgFileOpen.FileName;
                sFilePath = dlgFileOpen.FileName;
                sFileName = sFilePath.Substring(sFilePath.LastIndexOf("\\") + 1);
            }
        }

        private void btnStartDownload_Click(object sender, EventArgs e)
        {
            UInt32 lret         = 0;
            abFileData          = ReadFile(sFilePath);
            UInt32 pvUserParam  = 1000;
            UInt32 ulChannel    = 0;    //Up to now we support only channel 0
            UInt32 ulMode       = 0;

            switch(this.cmbMode.SelectedIndex)
            {
                case CONFIG:
                    ulMode = cifXUser.DOWNLOAD_MODE_CONFIG;
                    break;

                case FILE:
                    ulMode = cifXUser.DOWNLOAD_MODE_FILE;
                    break;

                case FW:
                    ulMode = cifXUser.DOWNLOAD_MODE_FIRMWARE;
                    break;

                case LIC:
                    ulMode = cifXUser.DOWNLOAD_MODE_LICENSECODE;
                    break;
            }

            if (cifXUser.hChannel != 0)
                //because of the greater Channel Mailbox, you should prefer the download via the xChannelDownload
                lret = cifXUser.xChannelDownload(ulMode, sFileName, abFileData, ref pvUserParam);
            else
                lret = cifXUser.xSysdeviceDownload(ulChannel, ulMode, sFileName, abFileData, ref pvUserParam);

            this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private byte[] ReadFile(string filePath)
        {
            byte[] buffer;
            FileStream fileStream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
            try
            {
                int length = (int)fileStream.Length;  // get file length
                buffer = new byte[length];            // create buffer
                int count;                            // actual number of bytes read
                int sum = 0;                          // total number of bytes read

                // read until Read method returns 0 (end of the stream has been reached)
                while ((count = fileStream.Read(buffer, sum, length - sum)) > 0)
                    sum += count;  // sum is a buffer offset for next reading
            }
            finally
            {
                fileStream.Close();
            }
            return buffer;
        }

    }
}